//
//  asmmath.s
//  AsmAttic
//
//  Created by Howard Oakley on 20/06/2021.
//
// ARM64 assembly program for floating point
// arithmetic comparison of
// a = ((((a * b) + c) - c)/b) + 1.0
// In:
//  D0 - double a
//  X0 - long loop count
// Out:
//  D0 - double a
// Used:
//  X4 - loop count max (input)
//  X5 - loop counter
//  D4 - a
//  D5 - b = 0.123456
//  D6 - c = 0.234567
//  D7 - 1.0

.global _testadd
.global _testadd2
.align 4

_testadd:
    STR     LR, [SP, #-16]!
    MOV     X5, #1
    MOV     X4, X0
    FMOV    D4, D0
    LDR     D5, B_DOUBLE
    LDR     D6, C_DOUBLE
    LDR     D7, INC_DOUBLE
for_loop:
    FMADD   D0, D4, D5, D6
    FSUB    D0, D0, D6
    FDIV    D4, D0, D5
    FADD    D4, D4, D7
    ADD     X5, X5, #1
    CMP     X5, X4
    B.LE    for_loop
    FMOV    D0, D4
    LDR     LR, [SP], #16
    RET

_testadd2:
    STR     LR, [SP, #-16]!
    MOV     X5, #1
    MOV     X4, X0
    ADD     X4, X4, #1
    FMOV    D4, D0
    LDR     D5, B_DOUBLE
    LDR     D6, C_DOUBLE
    LDR     D7, INC_DOUBLE
while_loop:
    CMP     X5, X4
    B.GE    while_done
    FMADD   D0, D4, D5, D6
    FSUB    D0, D0, D6
    FDIV    D4, D0, D5
    FADD    D4, D4, D7
    ADD     X5, X5, #1
    B       while_loop
while_done:
    FMOV    D0, D4
    LDR     LR, [SP], #16
    RET

INC_DOUBLE: .double     1.000000
B_DOUBLE:   .double     0.123456
C_DOUBLE:   .double     0.234567
