//
//  ViewController.swift
//  AsmAttic
//
//  Created by Howard Oakley on 06/06/2021.
//

import Cocoa

class ViewController: NSViewController, NSWindowDelegate {

    var theFontSize: CGFloat = 12.0
    var theNumerator: UInt64 = 0
    var theDenominator: UInt64 = 0

    @IBOutlet weak var no1Text: NSTextField!
    @IBOutlet weak var no1Formatter: NumberFormatter!
    @IBOutlet weak var no2Text: NSTextField!
    @IBOutlet weak var no2Formatter: NumberFormatter!
    @IBOutlet weak var no3Text: NSTextField!
    @IBOutlet weak var no3Formatter: NumberFormatter!
    @IBOutlet var outputText: NSTextView!
    
    func replaceOutputText(string: String) {
        var myFont = NSFont.monospacedSystemFont(ofSize: self.theFontSize, weight: NSFont.Weight.regular)
        let myString = NSAttributedString.init(string: string as String, attributes: [.foregroundColor : NSColor.textColor, .font : myFont])
        self.outputText.textStorage?.setAttributedString(myString)
        self.outputText.didChangeText()
    }
    
    func appendOutputText(string: String) {
        var myFont = NSFont.monospacedSystemFont(ofSize: self.theFontSize, weight: NSFont.Weight.regular)
        let myString = NSAttributedString.init(string: string as String, attributes: [.foregroundColor : NSColor.textColor, .font : myFont])
        self.outputText.textStorage?.append(myString)
        self.outputText.didChangeText()
    }

    override func viewDidLoad() {
        super.viewDidLoad()

        // Do any additional setup after loading the view.
    }

    override func viewDidAppear() {
        self.view.window?.delegate = self
        self.view.window?.title = "AsmAttic"
        var info = mach_timebase_info()
        mach_timebase_info(&info)
        self.theNumerator = UInt64(info.numer)
        self.theDenominator = UInt64(info.denom)
    }

    override var representedObject: Any? {
        didSet {
        // Update the view, if already loaded.
        }
    }
    
    func machToSecs(ticks: UInt64) -> Double {
        var theCorrTime: UInt64 = 0
        if self.theDenominator > 0 {
            theCorrTime = (ticks * self.theNumerator)/self.theDenominator
        }
        return (Double(theCorrTime)) * 0.000000001
    }
    
    func runSwiftTest(theA: Double, theReps: Int) -> Double {
        var tempA = theA
        var dZero = 0.0
        let theB = 0.123456
        let theC = 0.234567
        let theInc = 1.000000
        for _ in 1...theReps {
            //            tempA = ((((tempA * theB) + theC) - theC)/theB) + theInc
            dZero = (tempA * theB) + theC
            tempA = ((dZero - theC)/theB) + theInc
        }
        return tempA
    }

    @IBAction func goButton(_ sender: Any) {
        var theTime: Double = -1.0
        var theTime2: Double = -1.0
        var theTime3: Double = -1.0
        var theStart: UInt64 = 0
        var theEnd: UInt64 = 0
        var theEnd2: UInt64 = 0
        var theEnd3: UInt64 = 0
        if let theA = self.no1Formatter.number(from: self.no1Text.stringValue) {
            if let theB = self.no2Formatter.number(from: self.no2Text.stringValue) {
                //                if let theC = self.no3Formatter.number(from: self.no3Text.stringValue) {
                let myA = theA.doubleValue
                let myB = theB.intValue
                theStart = mach_absolute_time()
                let myD = testadd(myA, myB)
                theEnd = mach_absolute_time()
                let myE = testadd2(myA, myB)
                theEnd2 = mach_absolute_time()
                let myF = runSwiftTest(theA: myA, theReps: myB)
                theEnd3 = mach_absolute_time()
                theTime = self.machToSecs(ticks: (theEnd - theStart))
                theTime2 = self.machToSecs(ticks: (theEnd2 - theEnd))
                theTime3 = self.machToSecs(ticks: (theEnd3 - theEnd2))
                self.appendOutputText(string: "Result  for  = \(myD) time = \(theTime)\n")
                self.appendOutputText(string: "Result while = \(myE) time = \(theTime2)\n")
                self.appendOutputText(string: "Result Swift = \(myF) time = \(theTime3)\n")
                //                }
            }
        }
    }
    
}

